<?php
/**
 * ICEBERG - Descarga del proyecto como ZIP
 * Genera un ZIP de la carpeta proyecto/ y lo sirve para descargar.
 */

$projectDir = __DIR__ . '';
$zipName = 'iceberg-pos-proyecto.zip';

if (!is_dir($projectDir)) {
    die('Error: carpeta proyecto/ no encontrada');
}

// Crear ZIP en memoria temporal
$tmpFile = tempnam(sys_get_temp_dir(), 'iceberg_');
$zip = new ZipArchive();

if ($zip->open($tmpFile, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== true) {
    die('Error creando archivo ZIP');
}

// Funcion recursiva para agregar archivos
function addDirToZip($zip, $dir, $base) {
    $files = scandir($dir);
    foreach ($files as $file) {
        if ($file === '.' || $file === '..') continue;
        $fullPath = $dir . '/' . $file;
        $zipPath = substr($fullPath, strlen($base) + 1);

        if (is_dir($fullPath)) {
            $zip->addEmptyDir($zipPath);
            addDirToZip($zip, $fullPath, $base);
        } else {
            $zip->addFile($fullPath, $zipPath);
        }
    }
}

addDirToZip($zip, $projectDir, $projectDir);
$zip->close();

// Servir el ZIP
header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="' . $zipName . '"');
header('Content-Length: ' . filesize($tmpFile));
header('Cache-Control: no-cache, must-revalidate');
header('Pragma: no-cache');

readfile($tmpFile);
unlink($tmpFile);
exit;
