"""Endpoint de estado del hardware (proxy al Agent)."""
from fastapi import APIRouter
from schemas import HardwareStatus
from services.hardware_client import get_agent_status

router = APIRouter(prefix="/api", tags=["Hardware"])


@router.get("/hardware/status", response_model=HardwareStatus)
async def hardware_status():
    """Consulta si el programador esta conectado."""
    status = await get_agent_status()
    return HardwareStatus(**status)
