"""
Configuracion global de la app ICEBERG Manillas POS.

Tiempos en PRUEBAS (TEST_MODE = True):
  Verde  1 min   <- GRACE_MINUTES sobreescrito a 1 en test
  Azul   1 min   <- TEST_PLAY_MINUTES  (hardware tambien programado con 1 min)
  Rojo   1 min   <- TEST_RED_MINUTES   (hardware tambien programado con 1 min)

Tiempos en PRODUCCION (TEST_MODE = False):
  Verde  5 min   <- GRACE_MINUTES
  Azul   minutos reales del combo (hardware programado con los minutos del paquete)
  Rojo   8 min   <- RED_MINUTES
"""

APP_VERSION = "2.0.2"  # fallback
# Intentar leer version del config.json generado por el Operator
try:
    import os as _os, json as _json
    _cfg_path = _os.path.join(_os.path.dirname(_os.path.abspath(__file__)), "data", "config.json")
    if _os.path.exists(_cfg_path):
        with open(_cfg_path, "r", encoding="utf-8") as _f:
            _app_cfg = _json.load(_f)
        if "app_version" in _app_cfg:
            APP_VERSION = _app_cfg["app_version"]
except Exception:
    pass

TEST_MODE = False

# Fases de tiempo en modo PRUEBA (sobreescriben los de produccion para el hardware y la UI)
GRACE_MINUTES     = 1   # Fase verde  - 1 min en test, 5 min en produccion
TEST_PLAY_MINUTES = 1   # Fase azul   - solo en TEST_MODE (hardware Y barra)
TEST_RED_MINUTES  = 1   # Fase roja   - solo en TEST_MODE (hardware Y barra)

# Fases de tiempo en PRODUCCION
RED_MINUTES = 8         # Fase roja produccion - 8 min vibrando

# ---------------------------------------------------------------------------
# Paquetes por defecto (se usan si el servidor no esta disponible)
# ---------------------------------------------------------------------------
DEFAULT_PACKAGES = []
